{if $templateNameApplication == 'wbb' && $templateName == 'thread' && !$calendarEventDate|empty}
	<section class="section" id="calendarEventThreadBox">
		<h2 class="sectionTitle">{lang}calendar.event.date{/lang}</h2>
		
		<div class="row">
			<div class="col-xs-12 col-md-6">
				<div class="containerHeadline">
					<h3><a href="{link application='calendar' controller='Event' object=$calendarEventDate}{/link}" class="calendarEventLink" data-event-date-id="{@$calendarEventDate->eventDateID}">{$calendarEventDate->getEvent()->subject}</a></h3>
					<p>{@$calendarEventDate->getFormattedTimeFrame()}</p>
					{if $calendarEventDate->getEvent()->location}<p>{$calendarEventDate->getEvent()->location}</p>{/if}
				</div>
				{hascontent}
					<div class="calendarEventThreadRepetition">
						{content}
							{if $calendarEventDate->getNextEventDate()}
								<p><small>{lang}calendar.event.date.next{/lang}: <a href="{@$calendarEventDate->getNextEventDate()->getLink()}">{$calendarEventDate->getNextEventDate()->getFormattedTimeFrame()}</a></small></p>
							{/if}
							{if $calendarEventDate->getPreviousEventDate()}
								<p><small>{lang}calendar.event.date.previous{/lang}: <a href="{@$calendarEventDate->getPreviousEventDate()->getLink()}">{$calendarEventDate->getPreviousEventDate()->getFormattedTimeFrame()}</a></small></p>
							{/if}
						{/content}
					</div>
				{/hascontent}
			</div>
			
			{if $calendarEventDate->getEvent()->enableParticipation}
				<div class="col-xs-12 col-md-6">
					<div class="containerHeadline">
						<h3>{if $calendarEventDate->participants && $calendarEventDate->canViewParticipationList()}<a href="#" class="jsCalendarEventDateShowParticipants">{lang}calendar.event.participants{/lang}</a>{else}{lang}calendar.event.participants{/lang}{/if}</h3>
						<p>{lang}calendar.event.participants.summary{/lang}</p>
						<small>{lang}calendar.event.participation.endTime{/lang}: {@$calendarEventDate->getParticipationEndTime()|plainTime}</small>
					</div>
				</div>
			{/if}
		</div>
	</section>
	<script data-relocate="true" src="{@$__wcf->getPath('calendar')}js/Calendar.Event.Thread{if !ENABLE_DEBUG_MODE}.min{/if}.js?v={@LAST_UPDATE_TIME}"></script>
	<script data-relocate="true">
		new Calendar.Event.Thread.ShowParticipants({@$calendarEventDate->eventDateID});
	</script>
{/if}
