<?php
namespace wcf\system\bot;
use wcf\system\WCF;
use wcf\data\user\User;
use wcf\system\language\LanguageFactory;

/**
 * functions for the event bot (community bot system)
 *
 * @author	Kawas
 * @copyright	2013-2014 Kawas
 * @license	creative commons <http://creativecommons.org/licenses/by-sa/4.0/deed.de>
 * @package	com.kawas.wcf.bot
 * @category	Community Framework
 */
class BotSystem {

	/**
	 * group id of admins
	 * @var integer
	 */
	const ADMIN_GROUP_ID = 4;

	/**
	 * Returns all admins
	 *
	 * @return array<wcf\data\user\User>
	 */
	protected static function getAdmins() {
		$users = array();
		$sql = "SELECT user.* FROM wcf".WCF_N."_user user
		LEFT JOIN wcf".WCF_N."_user_to_group user_group
		  ON user.userID = user_group.userID
		WHERE user_group.groupID = ?";

		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array(self::ADMIN_GROUP_ID));
		while ($row = $statement->fetchArray()) {
			$users[] = new User(null, $row);
		}

		return $users;
	}

	/**
	 * Returns static parameters for actions
	 *
	 * @return array<integer>
	 */
	protected static function getStaticParameters() {
		return	array(
			'enable_bbcodes' => 1,
			'enable_smilies' => 0,
			'show_signature' => 1,
			'enable_html' => 0,
			'leave_conversation' => 0,
		);
	}

	/**
	 * create update messages
	 */
	public static function createInstallMessage() {
		if(!Bot::getInstance()->isEnabled('bot')) return;

		$sql = "SELECT user.* FROM wcf".WCF_N."_user user
		LEFT JOIN wcf".WCF_N."_user_to_group user_group
		  ON user.userID = user_group.userID
		WHERE user_group.groupID = ?";

		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array(4));

		foreach (self::getAdmins() as $user) {
			$languageObj = LanguageFactory::getInstance()->getLanguage($user->languageID);

			$parameters = Bot::createUserParameters($user);
			$parameters['subject'] = $languageObj->get('wcf.bot.template.bot.install.subject');
			$parameters['message'] = $languageObj->get('wcf.bot.template.bot.install.message');

			$parameters = array_merge($parameters, self::getStaticParameters());

			Bot::getInstance()->fireActions('bot', $parameters);
		}
	}

	/**
	 * create update messages
	 */
	public static function createUpdateMessage() {
		if(!Bot::getInstance()->isEnabled('bot')) return;

		$sql = "SELECT packageVersion FROM wcf".WCF_N."_package 
					WHERE package = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array('com.kawas.wcf.bot'));
		$row = $statement->fetchArray();
		$botVersion = $row['packageVersion'];

		foreach (self::getAdmins() as $user) {
			$languageObj = LanguageFactory::getInstance()->getLanguage($user->languageID);

			$parameters = Bot::createUserParameters($user);
			$parameters['version'] = $botVersion;
			$parameters['subject'] = $languageObj->get('wcf.bot.template.bot.update.subject');
			$parameters['message'] = $languageObj->get('wcf.bot.template.bot.update.message');

			$parameters = array_merge($parameters, self::getStaticParameters());

			Bot::getInstance()->fireActions('bot', $parameters);
		}
	}

	private function __construct() {}
}