<?php
namespace wcf\data\bot\action\log;
use wcf\data\DatabaseObjectEditor;
use wcf\system\WCF;
use wcf\system\bot\Bot;

/**
 * editor for action logs
 *
 * @author	Oskar Schaffner
 * @copyright	2013-2014 Oskar Schaffner
 * @license	creative commons <http://creativecommons.org/licenses/by-sa/4.0/deed.de>
 * @package	com.kawas.wcf.bot
 * @category	Community Framework
 */
class BotActionLogEditor extends DatabaseObjectEditor {

	/**
	 * @see	wcf\data\DatabaseObjectEditor::$baseClass
	 */
	protected static $baseClass = 'wcf\data\bot\action\log\BotActionLog';
	
	/**
	 * delete all log items of action
	 *
	 * @param integer $actionID 
	 */
	public static function resetAction($actionID) {
		$sql = "DELETE FROM ".static::getDatabaseTableName()."
					WHERE actionID = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array($actionID));

		Bot::getInstance()->forcingCronjob();
	}
	
}
