<?php
namespace wcf\data\bot\action;
use wcf\data\AbstractDatabaseObjectAction;
use wcf\data\IToggleAction;
use wcf\system\exception\SystemException;
use wcf\data\bot\action\log\BotActionLogEditor;

/**
 * 
 * 
 * @author	Oskar Schaffner
 * @copyright	2013-2014 Oskar Schaffner
 * @license	creative commons <http://creativecommons.org/licenses/by-sa/4.0/deed.de>
 * @package	com.kawas.wcf.bot
 * @category	Community Framework
 */
class BotActionAction extends AbstractDatabaseObjectAction implements IToggleAction {
	
	/**
	 * @see	wcf\data\AbstractDatabaseObjectAction::$className
	 */
	protected $className = 'wcf\data\bot\action\BotActionEditor';
	
	/**
	 * @see	wcf\data\AbstractDatabaseObjectAction::$permissionsDelete
	 */
	protected $permissionsDelete = array('admin.general.bot.canManageBot');
	
	/**
	 * @see	wcf\data\AbstractDatabaseObjectAction::$permissionsUpdate
	 */
	protected $permissionsUpdate = array('admin.general.bot.canManageBot');
	
	/**
	 * @see	\wcf\data\AbstractDatabaseObjectAction::$requireACP
	 */
	protected $requireACP = array('delete', 'toggle', 'update');
	
	/**
	 * @see	wcf\data\IToggleAction::toggle()
	 */
	public function toggle() {
		foreach ($this->objects as $action) {
			$action->update(array(
				'isDisabled' => $action->isDisabled ? 0 : 1
			));
		}
	}
	
	/**
	 * @see	wcf\data\IToggleAction::validateToggle()
	 */
	public function validateToggle() {
		parent::validateUpdate();
	}
	
	/**
	 * @see	wcf\data\IToggleAction::validateToggle()
	 */
	public function validateDelete() {
		parent::validateDelete();
		
		foreach ($this->objects as $action) {
			if ($action->isTemplate) throw new SystemException('Can not delete template action');
		}
	}

	/**
	 * reset the log of a action reset() 
	 */
	public function reset(){
		foreach ($this->objects as $action) {
			BotActionLogEditor::resetAction($action->actionID);
		}
	}

	/**
	 * @see	wcf\data\IToggleAction::validateToggle()
	 */
	public function validateReset() {
		parent::validateUpdate();
	}
	
	
}
