/**
 * Resets a action of the bot
 *
 * @author	Kawas
 * @copyright	2013-2014 Kawas
 * @license	creative commons <http://creativecommons.org/licenses/by-sa/4.0/deed.de>
 * @package	com.kawas.wcf.bot
 */
WCF.Action.Reset = WCF.Action.Toggle.extend({

	/**
	 * @see WCF.Action.Toggle.init()
	 */
	init: function(className, containerSelector, buttonSelector) {
		this._containerSelector = containerSelector;
		this._className = className;
		this._buttonSelector = (buttonSelector) ? buttonSelector : '.jsResetButton';
		
		this.proxy = new WCF.Action.Proxy({
			success: $.proxy(this._success, this)
		});
		
		this._initElements();
		
		WCF.DOMNodeInsertedHandler.addCallback('WCF.Action.Reset' + this._className.hashCode(), $.proxy(this._initElements, this));
	},

	/**
	 * @see WCF.Action.Toggle._sendRequest()
	 */
	_sendRequest: function(object) {
		this.proxy.setOption('data', {
			actionName: 'reset',
			className: this._className,
			objectIDs: [ $(object).data('objectID') ]
		});
		
		this.proxy.sendRequest();
	},

	/**
	 * @see WCF.Action.Toggle._toggleButton()
	 */
	_toggleButton: function($container, $toggleButton) {
		
		// toggle icon source
		WCF.LoadingOverlayHandler.updateIcon($toggleButton, false);

	}

});
